
##############################
# Country definition for ENG #
##############################

province =
{ id            = 5
  radar_station = { size = 1 current_size = 1 }
  anti_air      = 4
  air_base      = { size = 4 current_size = 4 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Scapa Flow
province =
{ id            = 6
  radar_station = { size = 1 current_size = 1 }
}                 # Inverness
province =
{ id            = 7
  naval_base    = { size = 5 current_size = 5 }
  radar_station = { size = 1 current_size = 1 }
}                 # Aberdeen
province =
{ id            = 8
  naval_base    = { size = 7 current_size = 7 }
  air_base      = { size = 8 current_size = 6 }
  radar_station = { size = 1 current_size = 1 }
}                 # Dunfermline
province =
{ id            = 12
  ic            = 6
  radar_station = { size = 2 current_size = 2 }
}                 # Blackpool
province =
{ id            = 13
  ic            = 14
  radar_station = { size = 2 current_size = 2 }
  anti_air      = 2
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Sheffield
province =
{ id            = 14
  ic            = 16
  anti_air      = 8
  radar_station = { size = 2 current_size = 2 }
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Liverpool
province =
{ id            = 15
  radar_station = { size = 1 current_size = 1 }
}                 # Cardiff
province =
{ id            = 17
  anti_air      = 8
  radar_station = { size = 3 current_size = 3 }
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Norwich
province =
{ id       = 19
  air_base = { size = 5 current_size = 5 }
}            # London
province =
{ id            = 20
  coastalfort   = 9
  anti_air      = 9
  radar_station = { size = 4 current_size = 4 }
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Dover
province =
{ id            = 21
  anti_air      = 10
  radar_station = { size = 4 current_size = 4 }
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Portsmouth
province =
{ id            = 22
  radar_station = { size = 1 current_size = 1 }
}                 # Bristol
province =
{ id            = 23
  anti_air      = 10
  radar_station = { size = 3 current_size = 3 }
  air_base      = { size = 10 current_size = 10 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Plymouth
province =
{ id         = 28
  naval_base = { size = 5 current_size = 5 }
  air_base   = 2
}              # Belfast
province =
{ id    = 66
  infra = { size = 1 current_size = 0.75 }
}         # Aachen
province =
{ id       = 67
  air_base = { size = 10 current_size = 8 }
  infra    = { size = 1 current_size = 0.75 }
  ic       = { size = 3 current_size = 0 }
}            # Essen
province =
{ id    = 76
  infra = { size = 1 current_size = 0.7 }
  ic    = { size = 4 current_size = 0 }
}         # Dortmund
province =
{ id         = 80
  air_base   = { size = 10 current_size = 8 }
  infra      = { size = 1 current_size = 0.7 }
  supplypool = 5000
  oilpool    = 500
  ic         = { size = 2 current_size = 0 }
}              # Wilhelmshafen
province =
{ id    = 81
  infra = { size = 1 current_size = 0.75 }
  ic    = { size = 4 current_size = 0 }
}         # Mnster
province =
{ id    = 86
  infra = { size = 1 current_size = 0.75 }
  ic    = { size = 3 current_size = 0 }
}         # Hannover
province =
{ id    = 88
  infra = { size = 1 current_size = 0.7 }
  ic    = { size = 2 current_size = 0 }
}         # Hamburg
province =
{ id         = 89
  naval_base = { size = 10 current_size = 8 }
  air_base   = { size = 10 current_size = 8 }
  infra      = { size = 1 current_size = 0.7 }
}              # Lbeck
province =
{ id    = 90
  infra = { size = 1 current_size = 0.8 }
  ic    = { size = 2 current_size = 0 }
}         # Kiel
province =
{ id            = 348
  supplypool    = 500
  oilpool       = 200
  landfort      = 10
  anti_air      = 10
  radar_station = { size = 2 current_size = 2 }
  air_base      = { size = 4 current_size = 4 }
  naval_base    = { size = 10 current_size = 10 }
}                 # Gibraltar
province =
{ id         = 399
  oilpool    = 100
  supplypool = 500
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 2 current_size = 2 }
}              # Rhodes
province =
{ id         = 404
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 3 current_size = 3 }
}              # Haifa
province =
{ id         = 406
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 2 current_size = 2 }
}              # Eilat
province =
{ id         = 444
  naval_base = { size = 4 current_size = 4 }
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
}              # Cyprus
province =
{ id    = 460
  infra = { size = 1 current_size = 0.75 }
  ic    = { size = 2 current_size = 0 }
}         # Graz
province =
{ id         = 461
  supplypool = 1000
  oilpool    = 100
  ic         = { size = 1 current_size = 0 }
  infra      = { size = 0.8 current_size = 0.6 }
}              # Klagenfurt
province =
{ id         = 538
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
  oilpool    = 100
  supplypool = 500
}              # Bermuda
province =
{ id            = 576
  naval_base    = { size = 4 current_size = 4 }
  air_base      = { size = 4 current_size = 4 }
  radar_station = { size = 1 current_size = 1 }
}                 # Newfoundland
province =
{ id       = 652
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Andros
province =
{ id         = 668
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Long Island
province =
{ id         = 866
  anti_air   = 2
  air_base   = { size = 2 current_size = 2 }
  naval_base = { size = 5 current_size = 5 }
  oilpool    = 100
  supplypool = 200
}              # Falkland Islands
province =
{ id       = 873
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Georgetown
province = { id = 900 anti_air = 6 } # Suez
province =
{ id         = 901
  anti_air   = 6
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 3 current_size = 3 }
}              # Port Said
province = { id = 903 anti_air = 6 } # Cairo
province =
{ id         = 906
  supplypool = 5000
  oilpool    = 2000
  anti_air   = 9
  air_base   = { size = 7 current_size = 7 }
  naval_base = { size = 10 current_size = 10 }
}              # Alexandria
province =
{ id         = 919
  anti_air   = 4
  landfort   = 6
  naval_base = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
}              # Tobruk
province =
{ id         = 923
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 3 current_size = 3 }
}              # Barca
province =
{ id         = 924
  anti_air   = 2
  naval_base = { size = 5 current_size = 5 }
  air_base   = { size = 4 current_size = 4 }
}              # Bengazi
province =
{ id         = 932
  anti_air   = 2
  oilpool    = 100
  supplypool = 500
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Tripoli
province =
{ id         = 933
  naval_base = { size = 5 current_size = 5 }
  air_base   = { size = 5 current_size = 5 }
}              # Zuara
province =
{ id         = 988
  anti_air   = 1
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
  oilpool    = 1000
  supplypool = 2000
}              # Freetown
province =
{ id       = 1002
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Accra
province =
{ id       = 1008
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Lagos
province =
{ id         = 1033
  anti_air   = 2
  oilpool    = 100
  supplypool = 500
  naval_base = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
}              # Massaua
province =
{ id         = 1038
  anti_air   = 4
  supplypool = 1000
  oilpool    = 1000
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
}              # Assab
province =
{ id         = 1056
  oilpool    = 100
  supplypool = 500
  naval_base = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
}              # Mogadishu
province =
{ id       = 1061
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mombasa
province =
{ id       = 1066
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Khartoum
province =
{ id       = 1287
  air_base = { size = 5 current_size = 5 }
}            # Imphal
province =
{ id       = 1296
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Mandalay
province =
{ id         = 1299
  anti_air   = 5
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 10 current_size = 10 }
}              # Rangoon
province =
{ id          = 1315
  landfort    = 9
  anti_air    = 8
  air_base    = { size = 4 current_size = 4 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 100
  supplypool  = 500
}               # Hong Kong
province =
{ id          = 1353

  coastalfort = 9
  anti_air    = 10
  air_base    = { size = 8 current_size = 8 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 1000
  supplypool  = 5000
}               # Singapore
province =
{ id         = 1457
  ic         = 3
  anti_air   = 5
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
}              # Calcutta
province = { id = 1459 oilpool = 100 supplypool = 500 } # Ranchi
province = { id = 1464 ic = 2 } # Surat
province = { id = 1465 ic = 4 } # Rajkot
province =
{ id         = 1466
  naval_base = { size = 8 current_size = 8 }
  air_base   = { size = 8 current_size = 8 }
}              # Ahmadabad
province =
{ id       = 1467
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Indore
province =
{ id       = 1469
  ic       = 19
  anti_air = 4
  air_base = { size = 4 current_size = 4 }
}            # Delhi
province = { id = 1478 ic = 5 } # Bikaner
province = { id = 1479 ic = 6 } # Jodhpur
province =
{ id         = 1494
  ic         = 2
  anti_air   = 1
  air_base   = { size = 8 current_size = 8 }
  naval_base = { size = 8 current_size = 8 }
}              # Karachi
province =
{ id         = 1505
  ic         = 4
  supplypool = 5000
  oilpool    = 2000
  anti_air   = 3
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Bombay
province = { id = 1513 ic = 4 } # Mangalore
province =
{ id       = 1514
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Cochin
province =
{ id            = 1516
  radar_station = { size = 2 current_size = 2 }
  anti_air      = 1
  air_base      = { size = 2 current_size = 2 }
  naval_base    = { size = 2 current_size = 2 }
}                 # Trincomalee
province =
{ id          = 1517
  coastalfort = 9
  anti_air    = 2
  air_base    = { size = 10 current_size = 10 }
  naval_base  = { size = 10 current_size = 10 }
  oilpool     = 1000
  supplypool  = 2000
}               # Colombo
province =
{ id       = 1644
  anti_air = 1
  air_base = { size = 4 current_size = 4 }
}            # Kuching
province =
{ id         = 1685
  supplypool = 2500
  oilpool    = 2000
  naval_base = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
}              # Guadalcanal
province =
{ id         = 1753
  supplypool = 500
  oilpool    = 200
  naval_base = { size = 8 current_size = 8 }
  air_base   = { size = 8 current_size = 8 }
}              # Vanua Levu

#####################
# Country main data #
#####################

country =
{ tag                    = ENG
  capital                = 19
  manpower               = 485
  # Resource Reserves
  energy                 = 5000
  metal                  = 5000
  rare_materials         = 2500
  oil                    = 500
  supplies               = 10000
  money                  = 500
  # #######################
  # ##CONVOYS##############
  # #######################
  transports             = 1600
  escorts                = 150
  dissent                = 4
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 10
    political_left    = 8
    freedom           = 10
    free_market       = 8
    professional_army = 5
    defense_lobby     = 5
    interventionism   = 6
  }
  #SpyInfo                = { country = "POR" NumberOfSpies = 8 }
  #SpyInfo                = { country = "SOV" NumberOfSpies = 12 }
  #SpyInfo                = { country = "SPA" NumberOfSpies = 12 }
  #SpyInfo                = { country = "ARG" NumberOfSpies = 6 }
  #SpyInfo                = { country = "TUR" NumberOfSpies = 6 }
  #SpyInfo                = { country = "SWE" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CHI" NumberOfSpies = 10 }
  #SpyInfo                = { country = "ROM" NumberOfSpies = 8 }
  #SpyInfo                = { country = "POL" NumberOfSpies = 10 }
  #SpyInfo                = { country = "YUG" NumberOfSpies = 6 }
  #SpyInfo                = { country = "HUN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "CZE" NumberOfSpies = 8 }
  #SpyInfo                = { country = "ALB" NumberOfSpies = 5 }
  #SpyInfo                = { country = "FIN" NumberOfSpies = 6 }
  #SpyInfo                = { country = "BUL" NumberOfSpies = 6 }
  SpyInfo                = { country = "ENG" NumberOfSpies = 12 }
  # GREAT BRITAIN
  nationalprovinces      = { 3    5    6    7    8    9    10   11   12   13   14   15   16   17   19   20   21   22   23   28   29   348  31   1494
                             1481 1480 1465 1466 1479 1482 1483 1475 1476 1478 1477 1877 1878 1469 1470 1471 1472 1456 1468 1467 1464 1463 1474 1460
                             1459 1457 1458 1461 1508 1462 1505 1506 1507 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1284 1285 1286 1287
                             1288 1289 1290 1291 1898 1295 1296 1301 1302 1346 1299 1298 1297 1300 1292 1454
                           }
  # GREAT BRITAIN
  ownedprovinces         = { 10   1000 1001 1002 1007 1008 1009 1010 1011 1012 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028
                             1029 1030 1031 1032 1033 1034 1035 1036 1038 1039 1040 1041 1055 1056 1058 1059 1060 1061 1062 1064 1065 1066 1067 1068
                             1069 1085 1099 11   1104 1105 1111 1112 1124 1125 1126 1128 1129 1132 1136 1139 1140 1141 1145 1147 1148 12   1284 1285
                             1286 1287 1288 1289 1290 1291 1292 1295 1296 1297 1298 1299 13   1300 1301 1302 1315 1346 1348 1349 1350 1351 1352 1353
                             14   1454 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1474 1475 1476 1477 1478
                             1479 1480 1481 1482 1483 1494 15   1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 16  
                             1611 1614 1622 1644 1647 1683 1684 1685 1686 17   1752 1753 1754 1755 1757 1758 1759 1760 1761 1763 1767 1768 1769 1770
                             1796 1797 1798 1799 1800 1801 1802 1803 1813 1814 1815 1816 1817 1822 1877 1878 1898 19   20   21   22   23   28   29  
                             3    31   348  399  4    404  406  407  444  460  461  5    538  575  576  6    652  653  66   664  665  666  668  67  
                             7    758  76   8    80   805  806  807  808  809  81   85   86   866  871  873  88   89   891  896  897  9    90   900 
                             901  902  903  904  905  906  907  908  909  910  911  912  913  914  915  916  917  918  919  920  921  922  923  924 
                             925  926  927  928  929  930  931  932  933  982  988  999 
                           }
  # GREAT BRITAIN
  controlledprovinces    = { 10   1000 1001 1002 1007 1008 1009 1010 1011 1012 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028
                             1029 1030 1031 1032 1033 1034 1035 1036 1038 1039 1040 1041 1055 1056 1058 1059 1060 1061 1062 1064 1065 1066 1067 1068
                             1069 1085 1099 11   1104 1105 1111 1112 1124 1125 1126 1128 1129 1132 1136 1139 1140 1141 1145 1147 1148 12   1284 1285
                             1286 1287 1288 1289 1290 1291 1292 1295 1296 1297 1298 1299 13   1300 1301 1302 1315 1346 1348 1349 1350 1351 1352 1353
                             14   1454 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1474 1475 1476 1477 1478
                             1479 1480 1481 1482 1483 1494 15   1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 16  
                             1611 1614 1622 1644 1647 1683 1684 1685 1686 17   1752 1753 1754 1755 1757 1758 1759 1760 1761 1763 1767 1768 1769 1770
                             1796 1797 1798 1799 1800 1801 1802 1803 1813 1814 1815 1816 1817 1822 1877 1878 1898 19   20   21   22   23   28   29  
                             3    31   348  399  4    404  406  407  444  460  461  5    538  575  576  6    652  653  66   664  665  666  668  67  
                             7    758  76   8    80   805  806  807  808  809  81   85   86   866  871  873  88   89   891  896  897  9    90   900 
                             901  902  903  904  905  906  907  908  909  910  911  912  913  914  915  916  917  918  919  920  921  922  923  924 
                             925  926  927  928  929  930  931  932  933  982  988  999 
                           }
  # Commonwealth Tech '36
  # UK 1939 techs
  # ######################
  techapps               = { 1010  1020  1030  1040  1050  1070  1080  1090  1100  1110  1120  1130  1140  1150  1160  1170  1180  1190  1200  1210  12100 12110 12120
                             12130 1220  1230  1240  1250  1260  1270  1280  1310  1320  1330  1340  1350  1360  14000 14010 14020 14030 15000 15010 15500
                             2010  2020  2030  2040  2050  2060  2070  2080  2090  2100  2110  2120  2150  2160  2170  2180  2190  2220  2230  2240  
			     2260  2270  2290  2300  2310  2320  2330  2340  2350  2360  2370  2380  2400  2410  2420  2430  2450  2460  2470  2480  
			     2490  2510  2520  2530  3010  3020  3030  3040  3050  3070  3080  3090  3100  3110  3130  3140  3150  3160  3190  3200  
			     3210  3220  3250  3260  3270  3280  3290  3320  3330  3340  3350  3360  3370  3400  3410  3420  3430  4010  4020  4030  
			     4040  4050  4060  4070  4080  4090  4100  4110  4120  4130  4140  4150  4160  4170  4180  4190  4200  4210  4220  4230  
			     4240  4250  4260  4270  4280  5010  5020  5030  5040  5050  5060  5070  5080  5090  5100  5110  5120  5130  5140  5150  
			     5160  5180  5190  5200  5210  5220  5230  5310  5320  5330  5340  5350  5360  5370  5380  5390  5400  5410  5420  5430  
			     5440  5450  5460  5470  5480  5490  5500  5510  5550  5560  5570  6010  6030  6110  6120  6130  6140  6170  6200  7010  
			     7140  7150  8010  8020  8030  8040  8050  8070  8090  8100  8110  8120  8130  8140  8160  8190  8200  8240  8250  8310  
			     8330  9010  9020  9030  9040  9050  9060  9070  9080  9090  9100  9110  9120  9130  9140  9150  9160  9170  9180  9190  
			     9200  9210  9220  9230  9240  9250  9260  9270  9280  9290  9300  9320  9340  9350  9360  9370  9380  9390    
			     9400  9420  9410  9430  9440  9450  9460                          
                           }
  inventions = { 8000 8001 8010 }
  diplomacy =
  { relation = { tag = AFG value = -75 }
    relation = { tag = ARG value = 75 }
    relation = { tag = AST value = 200 access = yes }
    relation = { tag = BEL value = 150 access = yes }
    relation = { tag = BHU value = 200 access = yes }
    relation = { tag = BUL value = 20 }
    relation = { tag = CAN value = 200 access = yes }
    relation =
    { tag        = DEN
      value      = 100
      guaranteed = { day = 19 month = april year = 1939 }
    }
    relation = { tag = FRA value = 150 access = yes }
    relation =
    { tag        = GRE
      value      = 50
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation =
    { tag        = HOL
      value      = 125
      guaranteed = { day = 19 month = april year = 1939 }
      access     = yes
    }
    relation = { tag = HUN value = -50 }
    relation = { tag = IRE value = 50 }
    relation = { tag = IRQ value = 100 access = yes }
    relation = { tag = ITA value = 100 access = yes }
    relation = { tag = MEX value = 50 }
    relation = { tag = NEP value = 200 access = yes }
    relation = { tag = NOR value = 90 }
    relation = { tag = NZL value = 200 access = yes }
    relation = { tag = OMN value = 150 access = yes }
    relation =
    { tag        = POL
      guaranteed = { day = 30 month = march year = 1939 }
    }
    relation =
    { tag        = POR
      value      = 100
      guaranteed = { day = 22 month = may year = 1939 }
    }
    relation =
    { tag        = ROM
      value      = 50
      guaranteed = { day = 13 month = april year = 1939 }
    }
    relation = { tag = SAF value = 200 access = yes }
    relation =
    { tag        = SAU
      value      = 100
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation =
    { tag        = SCH
      value      = 50
      guaranteed = { day = 19 month = april year = 1939 }
    }
    relation = { tag = SIA value = 70 }
    relation = { tag = SWE value = 80 }
    relation =
    { tag        = TUR
      value      = 75
      guaranteed = { day = 17 month = may year = 1938 }
    }
    relation = { tag = USA value = 150 }
    relation = { tag = VEN value = -10 }
    relation =
    { tag        = YEM
      value      = 150
      access     = yes
      guaranteed = { day = 11 month = february year = 1934 }
    }
    relation = { tag = ICL value = 150 access = yes }
    relation = { tag = BRU access = yes value = 200 }
    relation = { tag = PER value = 100 access = yes }
  }
  headofstate            = { type = 9 id = 1033 }
  headofgovernment       = { type = 9 id = 1040 }
  foreignminister        = { type = 9 id = 1047 }
  armamentminister       = { type = 9 id = 1067 }
  ministerofsecurity     = { type = 9 id = 1089 }
  ministerofintelligence = { type = 9 id = 1106 }
  chiefofstaff           = { type = 9 id = 1123 }
  chiefofarmy            = { type = 9 id = 1133 }
  chiefofnavy            = { type = 9 id = 1139 }
  chiefofair             = { type = 9 id = 1148 }
  dormant_ministers      = { 1001 1002 1004 1006 1007 1008 1009 1010 1031 1042 1049 1052 1053 1054 1068 1073 1081 1082 1090 1107 1119 1124 1127 1128 1131 1134 1140 1143 
                             1160 1162
                           }
  landunit =
  { id       = { type = 30251 id = 1 }
    name     = "1 "
    location = 88
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 1 }
      name          = "3Ħлʦ "
      extra         = engineer
      brigade_model = 0
      experience    = 80
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 2 }
      name          = "49''ʦ "
      experience    = 80
      extra         = sp_artillery
      brigade_model = 2
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 3 }
      name          = "53'ʿ'ʦ "
      extra         = artillery
      brigade_model = 5
      experience    = 80
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 4 }
      name          = "52'͵'ʦ "
      extra         = anti_air
      brigade_model = 2
      experience    = 80
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 5 }
      name          = "ʦ "
      extra         = light_armor_brigade
      brigade_model = 0
      experience    = 80
    }
    division =
    { type         = infantry
      model        = 5
      id           = { type = 30254 id = 6 }
      name         = "308 "
      experience   = 80
      strength     = 35
      max_strength = 35
    }
  }
  landunit =
  { id       = { type = 30251 id = 2 }
    name     = "8 "
    location = 85
    division =
    { type          = armor
      model         = 3
      id            = { type = 30254 id = 7 }
      name          = "7װʦ "
      extra         = heavy_armor
      brigade_model = 0
      experience    = 90
    }
    division =
    { type          = armor
      model         = 3
      id            = { type = 30254 id = 8 }
      name          = "11װʦ "
      extra         = tank_destroyer
      brigade_model = 2
      experience    = 90
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 9 }
      name          = "55''ʦ "
      experience    = 90
      extra         = artillery
      brigade_model = 6
    }
    division =
    { type         = paratrooper
      model        = 0
      id           = { type = 30254 id = 10 }
      name         = "1ս "
      strength     = 50
      max_strength = 50
      experience   = 90
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 11 }
      name          = "15'ո'ʦ "
      experience    = 90
      extra         = engineer
      brigade_model = 0
    }
  }
  landunit =
  { id       = { type = 30251 id = 3 }
    name     = "30 "
    location = 89
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 12 }
      name          = "43'˹'ʦ "
      experience    = 85
      extra         = engineer
      brigade_model = 0
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 13 }
      name          = "5Ħлʦ "
      experience    = 85
      extra         = artillery
      brigade_model = 5
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 14 }
      name          = "51'ߵ'ʦ "
      experience    = 85
      extra         = engineer
      brigade_model = 0
    }
    division =
    { type          = armor
      model         = 3
      id            = { type = 30254 id = 15 }
      name          = "װʦ "
      extra         = heavy_armor
      brigade_model = 1
      experience    = 85
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 16 }
      name          = "305 "
      strength      = 35
      max_strength  = 35
      experience    = 85
      extra         = anti_air
      brigade_model = 2
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 17 }
      name          = "301Ħлʦ "
      strength      = 35
      max_strength  = 35
      experience    = 85
      extra         = tank_destroyer
      brigade_model = 2
    }
  }
  landunit =
  { id       = { type = 30251 id = 4 }
    name     = "ž "
    location = 85
    division =
    { type          = hq
      model         = 2
      id            = { type = 30254 id = 18 }
      name          = "žܲ "
      extra         = anti_air
      brigade_model = 1
      experience    = 90
    }
  }
  landunit =
  { id       = { type = 30251 id = 5 }
    name     = "8ž "
    location = 460
    division =
    { type       = hq
      model      = 2
      id         = { type = 30254 id = 19 }
      name       = "8ž˾ "
      experience = 75
    }
  }
  landunit =
  { id       = { type = 30251 id = 6 }
    name     = "5 "
    location = 460
    division =
    { type          = armor
      model         = 3
      id            = { type = 30254 id = 20 }
      name          = "6װʦ "
      experience    = 75
      extra         = heavy_armor
      brigade_model = 1
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 21 }
      name          = "56'׶'ʦ "
      extra         = light_armor_brigade
      brigade_model = 0
      experience    = 75
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 22 }
      name          = "78Ħлʦ "
      experience    = 75
      extra         = light_armor_brigade
      brigade_model = 0
    }
  }
  landunit =
  { id       = { type = 30251 id = 7 }
    name     = "2 "
    location = 86
    division =
    { type          = motorized
      model         = 1
      id            = { type = 30254 id = 23 }
      name          = "1ʦ "
      experience    = 75
      extra         = artillery
      brigade_model = 5
    }
    division =
    { type         = armor
      model        = 3
      id           = { type = 30254 id = 24 }
      name         = "9װ "
      strength     = 35
      max_strength = 35
      experience   = 75
    }
  }
  landunit =
  { id       = { type = 30251 id = 8 }
    name     = "10 "
    location = 461
    division =
    { type          = motorized
      model         = 1
      id            = { type = 30254 id = 25 }
      name          = "10ӡȲʦ "
      experience    = 70
      extra         = engineer
      brigade_model = 0
    }
    division =
    { type          = motorized
      model         = 1
      id            = { type = 30254 id = 26 }
      name          = "4ӡȲʦ "
      experience    = 70
      extra         = anti_tank
      brigade_model = 3
    }
    division =
    { type          = motorized
      model         = 2
      id            = { type = 30254 id = 27 }
      name          = "1Ħлʦ "
      experience    = 70
      extra         = artillery
      brigade_model = 6
    }
    division =
    { type         = armor
      model        = 4
      id           = { type = 30254 id = 28 }
      name         = "7װ "
      strength     = 40
      max_strength = 40
      experience   = 70
    }
  }
  landunit =
  { id       = { type = 30251 id = 9 }
    name     = "14ž "
    location = 1353
    division =
    { type          = hq
      model         = 1
      id            = { type = 30254 id = 29 }
      name          = "14ž˾ "
      extra         = engineer
      brigade_model = 0
      experience    = 50
    }
  }
  landunit =
  { id       = { type = 30251 id = 10 }
    name     = "15 "
    location = 1797
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 30 }
      name       = "82ǲʦ "
      experience = 50
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 31 }
      name       = "81ǲʦ "
      experience = 50
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 32 }
      name       = "26ӡȲʦ "
      experience = 50
    }
    division =
    { type          = infantry
      model         = 5
      id            = { type = 30254 id = 33 }
      name          = "36ʦ "
      experience    = 55
      extra         = engineer
      brigade_model = 0
    }
  }
  landunit =
  { id       = { type = 30251 id = 11 }
    name     = "4 "
    location = 906
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 34 }
      name       = "5ӡȲʦ "
      experience = 55
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 35 }
      name       = "17ӡȲʦ "
      experience = 55
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 36 }
      name       = "20ӡȲʦ "
      experience = 55
    }
    division =
    { type          = infantry
      model         = 4
      id            = { type = 30254 id = 37 }
      name          = "14ӡȲʦ "
      experience    = 50
      extra         = engineer
      brigade_model = 0
    }
  }
  landunit =
  { id       = { type = 30251 id = 12 }
    name     = "33 "
    location = 1497
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 38 }
      name       = "19ӡȲʦ "
      experience = 45
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 39 }
      name       = "7ӡȲʦ "
      experience = 45
    }
    division =
    { type       = infantry
      model      = 4
      id         = { type = 30254 id = 40 }
      name       = "23ӡȲʦ "
      experience = 45
    }
    division =
    { type          = infantry
      model         = 5
      id            = { type = 30254 id = 41 }
      name          = "2ʦ "
      experience    = 45
      extra         = engineer
      brigade_model = 0
    }
  }
  landunit =
  { location = 348
    id       = { type = 30251 id = 13 }
    name     = "ֱ˾ "
    division =
    { experience    = 30
      id            = { type = 30254 id = 42 }
      name          = "ֱӷ "
      type          = infantry
      model         = 4
      strength      = 100
      extra         = anti_air
      brigade_model = 2
    }
  }
  landunit =
  { location = 31
    id       = { type = 30251 id = 14 }
    name     = "˾ "
    division =
    { experience    = 30
      id            = { type = 30254 id = 43 }
      name          = " "
      type          = infantry
      model         = 4
      strength      = 100
      extra         = anti_air
      brigade_model = 2
    }
  }
  landunit =
  { location = 444
    id       = { type = 30251 id = 15 }
    name     = "·˹˾ "
    division =
    { experience = 30
      id         = { type = 30254 id = 44 }
      name       = "·˹ "
      type       = garrison
      model      = 1
      strength   = 100
    }
  }
  # ##################################################################################################
  # Active Fleets
  # ##################################################################################################
  # #################
  # Home Fleet#
  navalunit =
  { name     = " "
    id       = { type = 30252 id = 1 }
    location = 5 # Scapa Flow
    base     = 5 # Scapa Flow
    division =
    { experience    = 30
      id            = { type = 30255 id = 1 }
      name          = "۾˺ "
      type          = escort_carrier
      model         = 0
    }
    division =
    { experience    = 30
      id            = { type = 30255 id = 2 }
      name          = "ŭ "
      type          = carrier
      extra         = cag
      model         = 1
      brigade_model = 4
    }
    division =
    { experience    = 30
      id            = { type = 30255 id = 3 }
      name          = "η "
      type          = carrier
      extra         = cag
      model         = 3
      brigade_model = 4
    }
    division =
    { experience = 0
      id         = { type = 30255 id = 300 }
      name       = "˺ "
      type       = escort_carrier
      model      = 3
    }
    division =
    { experience = 0
      id         = { type = 30255 id = 301 }
      name       = " "
      type       = escort_carrier
      model      = 3
    }
    division =
    { experience = 0
      id         = { type = 30255 id = 302 }
      name       = "ׯϺ "
      type       = escort_carrier
      model      = 3
    }
    division =
    { experience = 0
      id         = { type = 30255 id = 303 }
      name       = "ٺ "
      type       = escort_carrier
      model      = 3
    }
    division =
    { experience = 0
      id         = { type = 30255 id = 304 }
      name       = " "
      type       = escort_carrier
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 4 }
      name       = "Լ˹ "
      type       = battleship
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 5 }
      name       = "˺ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 6 }
      name       = "غ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 7 }
      name       = "Ӻ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 8 }
      name       = "лƶº "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 9 }
      name       = "ĺ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 10 }
      name       = "1֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 11 }
      name       = "2֧ "
      type       = destroyer
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 12 }
      name       = "3֧ "
      type       = destroyer
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 13 }
      name       = "4֧ "
      type       = destroyer
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 14 }
      name       = "5֧ "
      type       = destroyer
      model      = 2
    }
  }
  # #################
  # Reserve Fleet - Clyde#
  navalunit =
  { name     = "Ԥ "
    id       = { type = 30252 id = 2 }
    location = 28 # Glasgow
    base     = 28
    division =
    { experience    = 30
      id            = { type = 30255 id = 15 }
      name          = "޺ "
      type          = carrier
      extra         = cag
      model         = 1
      brigade_model = 4
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 16 }
      name       = "ɭ "
      type       = battleship
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 17 }
      name       = " "
      type       = battleship
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 18 }
      name       = " "
      type       = battleship
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 19 }
      name       = "ĺ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 20 }
      name       = " "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 21 }
      name       = "Ȩ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 22 }
      name       = "ķ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 23 }
      name       = "˺ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 24 }
      name       = "ӵķ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 25 }
      name       = "նغ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 26 }
      name       = " "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 27 }
      name       = " "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 28 }
      name       = "Ҷī˹ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 29 }
      name       = "ֺ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 30 }
      name       = "Ľ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 31 }
      name       = " "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 32 }
      name       = "Ŧ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 33 }
      name       = "ڸɴ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 34 }
      name       = " "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 35 }
      name       = "ŷ¶˿ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 36 }
      name       = "º "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 37 }
      name       = "ɺ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 38 }
      name       = "6֧ "
      type       = destroyer
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 39 }
      name       = "7֧ "
      type       = destroyer
      model      = 1
    }
  }
  # ######################
  # Mediterrean Fleet#
  navalunit =
  { name     = "к "
    id       = { type = 30252 id = 3 }
    location = 444 # Alexandria
    base     = 444
    division =
    { experience = 30
      id         = { type = 30255 id = 40 }
      name       = "϶ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 41 }
      name       = " "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 42 }
      name       = "ʺ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 43 }
      name       = "8֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 44 }
      name       = "9֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 45 }
      name       = "10֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 46 }
      name       = "11֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 47 }
      name       = "12֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 48 }
      name       = "13֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 49 }
      name       = "14֧ "
      type       = destroyer
      model      = 1
    }
  }
  # ###########################
  navalunit =
  { name     = "A "
    id       = { type = 30252 id = 4 }
    location = 21 # Southampton
    base     = 21
    division =
    { experience = 30
      id         = { type = 30255 id = 50 }
      name       = "ս "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 51 }
      name       = "˹ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 52 }
      name       = "Ǻ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 53 }
      name       = "޵ "
      type       = battleship
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 54 }
      name       = "ɭ "
      type       = battleship
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 55 }
      name       = "ȶ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 56 }
      name       = "˹ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 57 }
      name       = "ޱ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 58 }
      name       = "ˮ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 59 }
      name       = " "
      type       = light_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 60 }
      name       = "ҵ "
      type       = light_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 61 }
      name       = "ǲ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 62 }
      name       = " "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 63 }
      name       = "ֿ˹ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 64 }
      name       = "Ի "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 65 }
      name       = "˹ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 66 }
      name       = "˹غ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 67 }
      name       = " "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 68 }
      name       = "Ǻ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 69 }
      name       = "ë˹ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 70 }
      name       = "Ů "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 71 }
      name       = "Ӣۺ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 72 }
      name       = "Ӻ "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 73 }
      name       = "ں "
      type       = light_cruiser
      model      = 2
    }
  }
  navalunit =
  { name     = "B "
    id       = { type = 30252 id = 5 }
    location = 906 # Southampton
    base     = 906
    division =
    { experience    = 30
      id            = { type = 30255 id = 74 }
      name          = " "
      type          = carrier
      extra         = cag
      model         = 4
      brigade_model = 5
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 75 }
      name       = "ݺ "
      type       = light_cruiser
      model      = 4
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 76 }
      name       = "34֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 77 }
      name       = "35֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 78 }
      name       = "36֧ "
      type       = destroyer
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 79 }
      name       = "21֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 80 }
      name       = "º "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 81 }
      name       = "19֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 82 }
      name       = "20֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 83 }
      name       = "15֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 84 }
      name       = "16֧ "
      type       = destroyer
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 85 }
      name       = "17֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 86 }
      name       = "18֧ "
      type       = destroyer
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 87 }
      name       = "22֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 88 }
      name       = "23֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 89 }
      name       = "24֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 90 }
      name       = "25֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 91 }
      name       = "26֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 92 }
      name       = "27֧ "
      type       = destroyer
      model      = 0
    }
  }
  # ##########################
  # East Indies Taskforce#
  navalunit =
  { name     = "ӡȽ "
    id       = { type = 30252 id = 6 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { experience = 30
      id         = { type = 30255 id = 93 }
      name       = "Ǻ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 94 }
      name       = " "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 95 }
      name       = "28֧ "
      type       = destroyer
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 96 }
      name       = "29֧ "
      type       = destroyer
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 97 }
      name       = "30֧ "
      type       = destroyer
      model      = 1
    }
  }
  # #################
  # Eastern Fleet#
  navalunit =
  { name     = " "
    id       = { type = 30252 id = 7 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { experience    = 30
      id            = { type = 30255 id = 98 }
      name          = "ʤ "
      type          = carrier
      extra         = cag
      model         = 3
      brigade_model = 4
    }
    division =
    { experience    = 30
      id            = { type = 30255 id = 99 }
      name          = "ߺ "
      type          = carrier
      extra         = cag
      model         = 3
      brigade_model = 4
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 100 }
      name       = "ɯŮ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 101 }
      name       = " "
      type       = battlecruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 102 }
      name       = "˺ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 103 }
      name       = "˹ "
      type       = light_cruiser
      model      = 2
    }
  }
  # ###########################
  # Gibraltar Taskforce#
  navalunit =
  { name     = "H "
    id       = { type = 30252 id = 8 }
    location = 348 # Gibraltar
    base     = 348
    division =
    { experience = 30
      id         = { type = 30255 id = 104 }
      name       = " "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 105 }
      name       = "Ǻ "
      type       = light_cruiser
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 106 }
      name       = "Ů "
      type       = light_cruiser
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 107 }
      name       = "31֧ "
      type       = destroyer
      model      = 1
    }
  }
  # ##########################
  # Indian Ocean Fleet#
  navalunit =
  { name     = "ӡ󽢶 "
    id       = { type = 30252 id = 9 }
    location = 2027 # North-east of Madagascar, en route to Colombo
    base     = 1517
    division =
    { experience = 30
      id         = { type = 30255 id = 108 }
      name       = "Ŧ˹ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 109 }
      name       = "˺ "
      type       = heavy_cruiser
      model      = 1
    }
  }
  # ##########################
  # Far East Fleet#
  navalunit =
  { name     = "Զ "
    id       = { type = 30252 id = 10 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { experience    = 30
      id            = { type = 30255 id = 110 }
      name          = "Ժ "
      type          = carrier
      extra         = cag
      model         = 3
      brigade_model = 4
    }
    division =
    { experience    = 30
      id            = { type = 30255 id = 111 }
      name          = " "
      type          = carrier
      extra         = cag
      model         = 4
      brigade_model = 4
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 112 }
      name       = "¸Һ "
      type       = battleship
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 113 }
      name       = "˹ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 114 }
      name       = "׶غ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 115 }
      name       = "ʲպ "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 116 }
      name       = "ԱǺ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 117 }
      name       = " "
      type       = heavy_cruiser
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 118 }
      name       = "Ǻ "
      type       = light_cruiser
      model      = 3
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 119 }
      name       = "32֧ "
      type       = destroyer
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 120 }
      name       = "33֧ "
      type       = destroyer
      model      = 1
    }
  }
  # #########################
  # 1st Submarine Squadron#
  navalunit =
  { name     = "1Ǳͧ "
    id       = { type = 30252 id = 11 }
    location = 23 # Valetta
    base     = 23
    division =
    { experience = 30
      id         = { type = 30255 id = 121 }
      name       = "1Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 122 }
      name       = "2Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 123 }
      name       = "24Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 124 }
      name       = "25Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  # #########################
  # 3rd Submarine Squadron - Holy Loch#
  navalunit =
  { name     = "3Ǳͧ "
    id       = { type = 30252 id = 12 }
    location = 28 # Glasgow
    base     = 28
    division =
    { experience = 30
      id         = { type = 30255 id = 125 }
      name       = "3Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 126 }
      name       = "4Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 127 }
      name       = "5Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 128 }
      name       = "6Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 129 }
      name       = "7Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  # #########################
  # 4th Submarine Squadron - Trincomalee#
  navalunit =
  { name     = "4Ǳͧ "
    id       = { type = 30252 id = 13 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { experience = 30
      id         = { type = 30255 id = 130 }
      name       = "8Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 131 }
      name       = "9Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 132 }
      name       = "10Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
  }
  # #########################
  # 5th Submarine Squadron#
  navalunit =
  { name     = "5Ǳͧ "
    id       = { type = 30252 id = 14 }
    location = 21 # Portsmouth
    base     = 21
    division =
    { experience = 30
      id         = { type = 30255 id = 133 }
      name       = "11Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 134 }
      name       = "12Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 135 }
      name       = "13Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  # #########################
  # 6th Submarine Squadron - Blyth#
  navalunit =
  { name     = "6Ǳͧ "
    id       = { type = 30252 id = 15 }
    location = 23 # Newcastle
    base     = 23
    division =
    { experience = 30
      id         = { type = 30255 id = 136 }
      name       = "14Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  # #########################
  # 7th Submarine Squadron - Rothesay#
  navalunit =
  { name     = "7Ǳͧ "
    id       = { type = 30252 id = 16 }
    location = 28 # Glasgow
    base     = 28
    division =
    { experience = 30
      id         = { type = 30255 id = 137 }
      name       = "15Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 138 }
      name       = "16Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 139 }
      name       = "17Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 140 }
      name       = "18Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
  }
  # #########################
  # 8th Submarine Squadron - Trincomalee#
  navalunit =
  { name     = "8Ǳͧ "
    id       = { type = 30252 id = 17 }
    location = 1517 # Colombo
    base     = 1517
    division =
    { experience = 30
      id         = { type = 30255 id = 141 }
      name       = "19Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 142 }
      name       = "20Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
  }
  # #########################
  # 9th Submarine Squadron - Dundee#
  navalunit =
  { name     = "9Ǳͧ "
    id       = { type = 30252 id = 18 }
    location = 8 # Aberdeen
    base     = 8
    division =
    { experience = 30
      id         = { type = 30255 id = 143 }
      name       = "21Ǳ֧ͧ "
      type       = submarine
      model      = 1
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 144 }
      name       = "22Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  # #########################
  # 10th Submarine Squadron - Maddalena#
  navalunit =
  { name     = "10Ǳͧ "
    id       = { type = 30252 id = 19 }
    location = 525 # Cagliari / Sardegna
    base     = 525
    division =
    { experience = 30
      id         = { type = 30255 id = 145 }
      name       = "23Ǳ֧ͧ "
      type       = submarine
      model      = 2
    }
  }
  navalunit =
  { name     = "1佢 "
    id       = { type = 30252 id = 20 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { experience = 30
      id         = { type = 30255 id = 146 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 147 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 148 }
      name       = "Ů "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 149 }
      name       = "°ķ˹ص "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 150 }
      name       = "˹ǵ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 151 }
      name       = "ɶٱ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 152 }
      name       = "˹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 153 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 154 }
      name       = "׵¹ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "2佢 "
    id       = { type = 30252 id = 21 }
    location = 5 # Scapa Flow
    base     = 5
    division =
    { experience = 30
      id         = { type = 30255 id = 155 }
      name       = "Ȩ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 156 }
      name       = "۹ǹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 157 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 158 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 159 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 160 }
      name       = "ӡȵ۹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 161 }
      name       = "޵۹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 162 }
      name       = "ʼո "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 163 }
      name       = "ʼͳ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "3佢 "
    id       = { type = 30252 id = 22 }
    location = 21
    base     = 21
    division =
    { experience = 30
      id         = { type = 30255 id = 164 }
      name       = "ɯŮ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 165 }
      name       = "ôŮ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 166 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 167 }
      name       = "ɽķ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 168 }
      name       = "ɽķ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 169 }
      name       = "ɽķ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 170 }
      name       = "ɽķ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 171 }
      name       = "ɽķص "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 172 }
      name       = "ɽķҳ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "4佢 "
    id       = { type = 30252 id = 23 }
    location = 444 # Scapa Flow
    base     = 444
    division =
    { experience = 30
      id         = { type = 30255 id = 173 }
      name       = "۹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 174 }
      name       = "˹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 175 }
      name       = "۹ħ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 176 }
      name       = "ɽķĪȱ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 177 }
      name       = "1佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 178 }
      name       = "2佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 179 }
      name       = "3佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 180 }
      name       = "4佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 181 }
      name       = "5佢֧ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "5佢 "
    id       = { type = 30252 id = 24 }
    location = 444 # Alexandria
    base     = 444
    division =
    { experience = 30
      id         = { type = 30255 id = 182 }
      name       = "˹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 183 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 184 }
      name       = "۹ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 185 }
      name       = "6佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 186 }
      name       = "7佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 187 }
      name       = "8佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 188 }
      name       = "9佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 189 }
      name       = "10佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 190 }
      name       = "11佢֧ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "6佢 "
    id       = { type = 30252 id = 25 }
    location = 1353 # Alexandria
    base     = 1353
    division =
    { experience = 30
      id         = { type = 30255 id = 191 }
      name       = "˹ֱ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 192 }
      name       = "۹ҫ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 193 }
      name       = "ɽķ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 194 }
      name       = "12佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 195 }
      name       = "13佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 196 }
      name       = "14佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 197 }
      name       = "15佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 198 }
      name       = "16佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 199 }
      name       = "17佢֧ "
      type       = transport
      model      = 0
    }
  }
  navalunit =
  { name     = "7佢 "
    id       = { type = 30252 id = 26 }
    location = 1299 # Colombo
    base     = 1299
    division =
    { experience = 30
      id         = { type = 30255 id = 200 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 201 }
      name       = "ĸ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 202 }
      name       = " "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 203 }
      name       = "18佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 204 }
      name       = "19佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 205 }
      name       = "20佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 206 }
      name       = "21佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 207 }
      name       = "22佢֧ "
      type       = transport
      model      = 0
    }
    division =
    { experience = 30
      id         = { type = 30255 id = 208 }
      name       = "23佢֧ "
      type       = transport
      model      = 0
    }
  }
  # ############################
  # ROYAL AIR FORCE 1944 OOB####
  # ############################
  airunit =
  { location = 370
    base     = 370
    id       = { type = 30253 id = 1 }
    name     = "Ӣʼҿվ10վ "
    division =
    { experience = 40
      id         = { type = 30256 id = 1 }
      name       = "126ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 2 }
      name       = "165ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 3 }
      name       = "ʼҼôվ406ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 4 }
      name       = "ʼҰĴǿվ464ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
  }
  airunit =
  { location = 80
    base     = 80
    id       = { type = 30253 id = 2 }
    name     = "Ӣʼҿվ11վ "
    division =
    { experience = 40
      id         = { type = 30256 id = 5 }
      name       = "1ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 6 }
      name       = "501ж  "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 45
      id         = { type = 30256 id = 7 }
      name       = "219ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
    division =
    { experience = 54
      id         = { type = 30256 id = 8 }
      name       = "29ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
  }
  airunit =
  { location = 46
    base     = 46
    id       = { type = 30253 id = 3 }
    name     = "2սվӵ1 "
    division =
    { experience = 50
      id         = { type = 30256 id = 9 }
      name       = "3ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 10 }
      name       = "33ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 11 }
      name       = "245ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 12 }
      name       = "694ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { location = 21
    base     = 21
    id       = { type = 30253 id = 4 }
    name     = "2սվӵ2 "
    division =
    { experience = 42
      id         = { type = 30256 id = 13 }
      name       = "65ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 42
      id         = { type = 30256 id = 14 }
      name       = "181ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 15 }
      name       = "ʼҼôվ401ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 16 }
      name       = "610ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { location = 51
    base     = 51
    id       = { type = 30253 id = 5 }
    name     = "Ӣʼҿվ12վ "
    division =
    { experience = 45
      id         = { type = 30256 id = 17 }
      name       = "168ж "
      strength   = 75
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 18 }
      name       = "25ж "
      strength   = 75
      type       = tactical_bomber
      model      = 4
    }
    division =
    { experience = 45
      id         = { type = 30256 id = 19 }
      name       = "264ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
    division =
    { experience = 55
      id         = { type = 30256 id = 20 }
      name       = "303ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { location = 20
    base     = 20
    id       = { type = 30253 id = 6 }
    name     = "Ӣʼҿվ13վ "
    division =
    { experience = 30
      id         = { type = 30256 id = 21 }
      name       = "504ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 22 }
      name       = "ʼҼôվ412ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 10
      id         = { type = 30256 id = 23 }
      name       = "308ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
  }
  airunit =
  { location = 20
    base     = 20
    id       = { type = 30253 id = 7 }
    name     = "Ӣʼҿվ14վ "
    division =
    { experience = 30
      id         = { type = 30256 id = 24 }
      name       = "118ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 25 }
      name       = "ʼҼôվ441ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 10
      id         = { type = 30256 id = 26 }
      name       = "331ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
  }
  airunit =
  { location = 8
    base     = 8
    id       = { type = 30253 id = 8 }
    name     = "Ӣʼҿվ38վ "
    division =
    { experience = 30
      id         = { type = 30256 id = 27 }
      name       = "190ж "
      strength   = 100
      type       = naval_bomber
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 28 }
      name       = "297ж "
      strength   = 100
      type       = naval_bomber
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 29 }
      name       = "570ж "
      strength   = 100
      type       = naval_bomber
      model      = 2
    }
  }
  airunit =
  { location = 67
    base     = 67
    id       = { type = 30253 id = 9 }
    name     = "603ж "
    division =
    { experience = 50
      id         = { type = 30256 id = 30 }
      name       = "603ж  "
      strength   = 100
      type       = interceptor
      model      = 4
    }
  }
  airunit =
  { location = 348
    base     = 348
    id       = { type = 30253 id = 10 }
    name     = "43ж "
    division =
    { experience = 50
      id         = { type = 30256 id = 31 }
      name       = "43ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
  }
  # ## pac air OOB 1944 Author: valdemar
  airunit =
  { location = 1457
    base     = 1457
    id       = { type = 30253 id = 11 }
    name     = "˾1վ "
    division =
    { experience = 50
      id         = { type = 30256 id = 32 }
      name       = "17/67/81ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 33 }
      name       = "36/155ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 34 }
      name       = "607/615ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 45
      id         = { type = 30256 id = 35 }
      name       = "28/30ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { location = 404
    base     = 404
    id       = { type = 30253 id = 12 }
    name     = "˾2վ "
    division =
    { experience = 30
      id         = { type = 30256 id = 36 }
      name       = "5/11/20ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 37 }
      name       = "42/34/42ж "
      strength   = 100
      type       = cas
      model      = 2
    }
    division =
    { experience = 65
      id         = { type = 30256 id = 38 }
      name       = "60/79ж "
      strength   = 100
      type       = cas
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 39 }
      name       = "183ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { location = 1287
    base     = 1287
    id       = { type = 30253 id = 13 }
    name     = "˾3վ"
    division =
    { experience    = 50
      id            = { type = 30256 id = 40 }
      name          = "200/203/215ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 70
      id            = { type = 30256 id = 41 }
      name          = "99/159ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 42 }
      name          = "292/355/356ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 50
      id            = { type = 30256 id = 43 }
      name          = "ʼҼôվ429ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 1287
    base     = 1287
    id       = { type = 30253 id = 14 }
    name     = "˾4վ"
    division =
    { experience = 30
      id         = { type = 30256 id = 44 }
      name       = "27/47/88ж "
      strength   = 100
      type       = naval_bomber
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 45 }
      name       = "176/177/211ж "
      strength   = 100
      type       = naval_bomber
      model      = 2
    }
  }
  airunit =
  { location = 906
    base     = 906
    id       = { type = 30253 id = 15 }
    name     = "˾5վ "
    division =
    { experience = 30
      id         = { type = 30256 id = 46 }
      name       = "31/62/117ж "
      strength   = 100
      type       = transport_plane
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 47 }
      name       = "194/435/436ж "
      strength   = 100
      type       = transport_plane
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 48 }
      name       = "45ж "
      strength   = 40
      type       = tactical_bomber
      model      = 4
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 49 }
      name       = "692ж "
      strength   = 100
      type       = tactical_bomber
      model      = 4
    }
  }
  # ########################################
  # ##form. can. inc
  airunit =
  { location = 23
    base     = 23
    id       = { type = 30253 id = 16 }
    name     = "Ӣʼҿվ1վ "
    division =
    { experience    = 60
      id            = { type = 30256 id = 50 }
      name          = "12ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 51 }
      name          = "103ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 52 }
      name          = "300ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 53 }
      name          = "576ж  "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 14
    base     = 14
    id       = { type = 30253 id = 17 }
    name     = "Ӣʼҿվ3վ "
    division =
    { experience    = 30
      id            = { type = 30256 id = 54 }
      name          = "15ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 55 }
      name          = "115ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 56 }
      name          = "218ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 40
      id            = { type = 30256 id = 57 }
      name          = "106ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 17
    base     = 17
    id       = { type = 30253 id = 18 }
    name     = "Ӣʼҿվ4վ "
    division =
    { experience    = 60
      id            = { type = 30256 id = 58 }
      name          = "10ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 59 }
      name          = "76ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 60 }
      name          = "78ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 61 }
      name          = "640ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 13
    base     = 13
    id       = { type = 30253 id = 19 }
    name     = "Ӣʼҿվ5վ "
    division =
    { experience    = 30
      id            = { type = 30256 id = 62 }
      name          = "9ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 63 }
      name          = "49ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 30
      id            = { type = 30256 id = 64 }
      name          = "467ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 50
      id            = { type = 30256 id = 65 }
      name          = "619ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 19
    base     = 19
    id       = { type = 30253 id = 20 }
    name     = "Ӣʼҿվ6վ "
    division =
    { experience    = 30
      id            = { type = 30256 id = 66 }
      name          = "ʼҼôվ408ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 40
      id            = { type = 30256 id = 67 }
      name          = "ʼҼôվ424ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 50
      id            = { type = 30256 id = 68 }
      name          = "ʼҼôվ427ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 40
      id            = { type = 30256 id = 69 }
      name          = "ʼҼôվ432ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { location = 19
    base     = 19
    id       = { type = 30253 id = 21 }
    name     = "Ӣʼҿվ8վ "
    division =
    { experience    = 60
      id            = { type = 30256 id = 70 }
      name          = "7ж "
      strength      = 75
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 71 }
      name          = "156ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 72 }
      name          = "582ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 73 }
      name          = "346ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  airunit =
  { id       = { type = 30253 id = 22 }
    name     = "Ӣʼҿվ16վ "
    location = 20
    base     = 20
    division =
    { experience = 50
      id         = { type = 30256 id = 74 }
      name       = "313ж  "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 75 }
      name       = "64ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 50
      id         = { type = 30256 id = 76 }
      name       = "332ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 77 }
      name       = "132ж "
      strength   = 100
      type       = multi_role
      model      = 2
    }
  }
  airunit =
  { id       = { type = 30253 id = 23 }
    name     = "Ӣʼҿվ18վ "
    location = 47
    base     = 47
    division =
    { experience = 40
      id         = { type = 30256 id = 78 }
      name       = "184ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 30
      id         = { type = 30256 id = 79 }
      name       = "80ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 40
      id         = { type = 30256 id = 80 }
      name       = "137ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
    division =
    { experience = 45
      id         = { type = 30256 id = 81 }
      name       = "ôʼҿվ416ж "
      strength   = 100
      type       = interceptor
      model      = 4
    }
  }
  airunit =
  { id       = { type = 30253 id = 523 }
    name     = "Mk IIIж "
    location = 19
    base     = 19
    division =
    { experience = 40
      id         = { type = 30256 id = 578 }
      name       = "Mk IIIж "
      strength   = 50
      type       = interceptor
      model      = 7
    }
  }
  airunit =
  { id       = { type = 30253 id = 24 }
    name     = "Ӣʼҿվ9վ "
    location = 67
    base     = 67
    division =
    { experience = 55
      id         = { type = 30256 id = 82 }
      name       = "82/84/110ж "
      strength   = 100
      type       = cas
      model      = 2
    }
    division =
    { experience = 55
      id         = { type = 30256 id = 83 }
      name       = "258/261/273ж "
      strength   = 100
      type       = cas
      model      = 2
    }
    division =
    { experience = 45
      id         = { type = 30256 id = 84 }
      name       = "135/146/152ж "
      strength   = 100
      type       = cas
      model      = 2
    }
    division =
    { experience = 60
      id         = { type = 30256 id = 85 }
      name       = "113/123/134ж "
      strength   = 100
      type       = cas
      model      = 2
    }
  }
  airunit =
  { id       = { type = 30253 id = 25 }
    name     = "Ӣʼҿվ7վ "
    location = 28
    base     = 28
    division =
    { experience    = 50
      id            = { type = 30256 id = 86 }
      name          = "61ж "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
    division =
    { experience    = 60
      id            = { type = 30256 id = 87 }
      name          = "625ж  "
      strength      = 100
      type          = strategic_bomber
      model         = 2
      extra         = escort
      brigade_model = 1
    }
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = november year = 1945 }
    cost          = 6
    days          = 100
    id            = { type = 30254 id = 45 }
    name          = "303Ħлʦ "
    extra         = artillery
    brigade_model = 6
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = november year = 1945 }
    cost          = 6
    days          = 100
    id            = { type = 30254 id = 46 }
    name          = "305Ħлʦ "
    extra         = artillery
    brigade_model = 6
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = november year = 1945 }
    cost          = 7
    days          = 100
    id            = { type = 30254 id = 47 }
    name          = "307Ħлʦ "
    extra         = sp_artillery
    brigade_model = 2
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = december year = 1945 }
    cost          = 7
    days          = 100
    id            = { type = 30254 id = 48 }
    name          = "401Ħлʦ "
    extra         = sp_artillery
    brigade_model = 2
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = december year = 1945 }
    cost          = 5
    days          = 100
    id            = { type = 30254 id = 49 }
    name          = "402Ħлʦ "
    extra         = anti_tank
    brigade_model = 3
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = december year = 1946 }
    cost          = 5
    days          = 100
    id            = { type = 30254 id = 50 }
    name          = "501Ħлʦ "
    extra         = anti_tank
    brigade_model = 3
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = january year = 1946 }
    cost          = 7
    days          = 100
    id            = { type = 30254 id = 51 }
    name          = "412Ħлʦ "
    extra         = tank_destroyer
    brigade_model = 2
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = january year = 1946 }
    cost          = 7
    days          = 100
    id            = { type = 30254 id = 52 }
    name          = "333Ħлʦ "
    extra         = tank_destroyer
    brigade_model = 2
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = january year = 1946 }
    cost          = 5
    days          = 100
    id            = { type = 30254 id = 53 }
    name          = "313Ħлʦ "
    extra         = light_armor_brigade
    brigade_model = 0
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = february year = 1946 }
    cost          = 5
    days          = 100
    id            = { type = 30254 id = 54 }
    name          = "311Ħлʦ "
    extra         = light_armor_brigade
    brigade_model = 0
  }
  division_development =
  { type          = motorized
    model         = 2
    date          = { day = 0 month = february year = 1946 }
    cost          = 7
    days          = 100
    id            = { type = 30254 id = 55 }
    name          = "405Ħлʦ "
    extra         = sp_artillery
    brigade_model = 2
  }
  division_development =
  { type          = armor
    model         = 3
    date          = { day = 0 month = november year = 1945 }
    cost          = 10
    days          = 185
    id            = { type = 30254 id = 56 }
    name          = "17װʦ "
    extra         = sp_artillery
    brigade_model = 2
  }
  division_development =
  { type          = armor
    model         = 3
    date          = { day = 0 month = december year = 1945 }
    cost          = 10
    days          = 185
    id            = { type = 30254 id = 57 }
    name          = "19װʦ "
    extra         = sp_artillery
    brigade_model = 2
  }
  division_development =
  { type          = armor
    model         = 3
    date          = { day = 0 month = january year = 1946 }
    cost          = 10
    days          = 185
    id            = { type = 30254 id = 58 }
    name          = "21װʦ "
    extra         = heavy_armor
    brigade_model = 1
  }
  division_development =
  { type          = armor
    model         = 3
    date          = { day = 0 month = february year = 1946 }
    cost          = 10
    days          = 185
    id            = { type = 30254 id = 59 }
    name          = "31װʦ "
    extra         = heavy_armor
    brigade_model = 1
  }
  division_development =
  { type  = escort_carrier
    model = 3
    date  = { day = 9 month = february year = 1946 }
    cost  = 5
    days  = 185
    id    = { type = 30255 id = 400 }
    name  = "˹ "
  }
  division_development =
  { type  = escort_carrier
    model = 3
    date  = { day = 14 month = march year = 1946 }
    cost  = 5
    days  = 220
    id    = { type = 30255 id = 600 }
    name  = "ʿ "
  }

  division_development =
  { type  = escort_carrier
    model = 3
    date  = { day = 9 month = may year = 1946 }
    cost  = 5
    days  = 255
    id    = { type = 30255 id = 601 }
    name  = "ɹ "
  }
}
